function [impute_replace,impute_noreplace,pcaU,pcaS,pcaV]=nets_impute(impute_input,Npca,varargin)

% nets_impute(impute_input,Npca,Nrand) 
% [....,impute_replace_std,impute_noreplace_std] = nets_impute(impute_input,Npca,Nrand)
% inpute missing data in matrix impute_input based on a soft-shrunk PCA data recon with Npca dimensions
% impute_replace is output where estimated data is replaced with (non-missing) input data
% impute_noreplace is output where estimated data is not replaced with input data (ie output is directly from PCA)
% Nrand runs with Nrand randomised missing-data initialisations and averages over these for main outputs, as well as giving stds
% set Npca to -1 to do dumb mean-imputation

pcaS0=0;
Nrand=0;
if nargin==3
  Nrand=varargin{1};
end

NpcaINT = min(Npca*2,min(size(impute_input)));
disp(sprintf('warning - new version (as of 14/10/24) uses an internal PCA dimensionality that is twice the output dimensionality, instead of the same dimensionality'))

OrigMean=nanmean(impute_input);  impute_input=impute_input-OrigMean;

if size(impute_input,2)==1 | Npca<0

  impute_replace=impute_input; impute_replace(isnan(impute_replace))=0;
  impute_noreplace=impute_replace; pcaU=impute_replace; pcaS=1; pcaV=1;

else

  for r = 1:max(1,Nrand)

    impute_corr=0;
    nanmask=isnan(impute_input);
    if Nrand==0
      impute_noreplace=zeros(size(impute_input));
    else
      impute_noreplace=randn(size(impute_input)) .* nanstd(impute_input) /2;
    end

    while (impute_corr<0.9999 | isnan(impute_corr))
      impute_replace=impute_input;
      impute_replace(nanmask)=impute_noreplace(nanmask);
      [pcaU,pcaS,pcaV]=nets_svds(impute_replace,NpcaINT);
      %%if size(pcaS0,2)==1,  pcaS0=pcaS;  end;
      pcaSmin=min(diag(pcaS));
      pcaSnew = pcaS - diag(((0:(size(pcaS,1)-1))/(size(pcaS,1)-1)).^4*pcaSmin) ;
      %%figure; plot([ diag(pcaS0) diag(pcaS) diag(pcaSnew)]);
      impute_noreplace = pcaU * pcaSnew *pcaV' ;
      if sum(nanmask(:))<2             % if <2 missing data elements
        impute_corr=impute_corr+0.3;   % do just a few iterations
      else  
        impute_corr=corr(impute_replace(nanmask),impute_noreplace(nanmask));
      end
    end

    if Nrand>0
       grot(:,:,r)=impute_replace;
    end  
  end

  if Nrand>0
    impute_replace=mean(grot,3);
  end

  pcaU=pcaU(:,1:Npca); pcaS=pcaS(1:Npca,1:Npca); pcaV=pcaV(:,1:Npca);
end

impute_replace=impute_replace+OrigMean;
impute_noreplace=impute_noreplace+OrigMean;

