function x=nets_normalise(x,dim)

% nets_normalise(X) 
% Removes the Average or mean value and makes the std=1
%
% nets_normalise(X,DIM)
% Removes the mean and makes the std=1 along the dimension DIM of X. 

if(nargin==1),
   dim = 1;
   if(size(x,1) > 1)
      dim = 1;
   elseif(size(x,2) > 1)
      dim = 2;
   end;
end;

dims = size(x);
dimsize = size(x,dim);
dimrep = ones(1,length(dims));
dimrep(dim) = dimsize;

x = x - repmat(nanmean(x,dim),dimrep);
x = x./repmat(nanstd(x,0,dim),dimrep);

x(isinf(x))=0;

