
% nets_unconfound(y,conf) 
% nets_unconfound(y,conf,-1) 
% regresses conf out of y, handling missing data
% data, confounds and output are all demeaned unless the "-1" option is included

function yd=nets_unconfound_par(y,conf,varargin)

DEMEAN=1;
if nargin==3
  DEMEAN=0;
end

if DEMEAN
  y = nets_demean(y);
  conf = nets_demean(conf);
end

if sum(isnan(y(:)))+sum(isnan(conf(:))) == 0   % if there's no missing data, can use faster code

  conf=nets_svds(conf,rank(conf)); beta=conf'*y; beta(abs(beta)<1e-10)=0; yd=y-conf*beta;

  if DEMEAN
    yd = nets_demean( yd );
  end

else

  yd = zeros(size(y));  % set to all 0

  %if isempty(gcp('nocreate'))                   % only setup pool of workers if it's not already setup
  %  grot=parcluster; parpool(grot.NumWorkers);  % setup max allowed pool of parallel workers
  %end
  parfor i=1:size(y,2)
    grot=~isnan(sum([y(:,i) conf],2));
    if (sum(grot)>5)  % need more intelligent threshold
      ydd=(y(:,1)*0)/0; % temporary output column to try to make parfor work
      grotconf = conf(grot,:);
      if DEMEAN
        grotconf=nets_demean(grotconf);
      end

      grotconf=nets_svds(grotconf,rank(grotconf)); 
      beta=grotconf'*y(grot,i); beta(abs(beta)<1e-10)=0; ydd(grot)=y(grot,i)-grotconf*beta;

      if DEMEAN
        ydd(grot) = nets_demean( ydd(grot) );
      end
      yd(:,i)=ydd;
    end
  end

end

